# 画面設計書 15-SQL Execution Detail（SQL実行詳細）

## 概要

本ドキュメントは、Apache Spark Application UIのSQL / DataFrameタブにあるSQL実行詳細画面の設計内容を記述する。本画面は特定SQL実行の物理プラン・DAGグラフ・関連ジョブ一覧・設定情報を表示する。

### 本画面の処理概要

**業務上の目的・背景**：Spark SQLクエリのパフォーマンスチューニングやデバッグにおいて、物理実行計画の可視化は不可欠である。本画面により、データエンジニアはSQL実行の物理プランをDAGグラフとして視覚的に確認でき、各ノードのメトリクス（読み込み行数、出力行数等）を確認することで、パフォーマンスのボトルネックとなるオペレータを特定できる。また、関連するSparkジョブへのリンクにより、詳細なステージ・タスクレベルの分析への導線も提供する。

**画面へのアクセス方法**：SQL実行一覧画面（No.14）のDescription列にあるリンクをクリックするか、URLに直接実行IDを指定してアクセスする。URLパラメータとしてidが必要。

**主要な操作・処理内容**：
1. サマリー情報（投入時刻、実行時間、関連ジョブID）を確認する
2. Plan Visualizationセクションでの物理実行プランのDAGグラフを確認する
3. DAGグラフのノードをクリックしてメトリクス詳細を確認する
4. Plan Detailsセクションでテキスト形式の物理プランを確認する
5. SQL / DataFrame Propertiesセクションで変更された設定を確認する
6. Pandas API Propertiesセクションでpandas on Spark設定を確認する
7. ジョブIDリンクからジョブ詳細画面へ遷移する
8. DAGグラフをSVG/DOT/TXT形式でダウンロードする
9. Stage ID・Task IDチェックボックスで最大メトリクスの対応情報を表示する

**画面遷移**：SQL実行一覧画面（No.14）から遷移してくる。本画面からジョブ詳細画面（No.2）へ遷移可能。親実行・子実行へのリンクも提供。

**権限による表示制御**：ACL設定が有効な場合、閲覧権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | Spark Web UI | 主機能 | 特定SQL実行の物理プラン・DAGグラフ・関連ジョブ一覧を表示する主処理 |
| 20 | Catalystオプティマイザ | 主機能 | 物理実行計画（Physical Plan）のノードグラフを可視化して表示 |
| 22 | コード生成（Whole-Stage CodeGen） | 補助機能 | WholeStageCodegenの実行ノード情報をDAG内に表示 |
| 3 | DAGスケジューラ | 遷移先機能 | 関連ジョブへのリンクを提供しジョブ詳細画面への遷移を実現 |
| 95 | KVStore | API連携 | SQLAppStatusStore.execution()経由で特定SQL実行データを非同期取得 |

## 画面種別

詳細

## URL/ルーティング

- パス: `/SQL/execution/`
- パラメータ: `id` (必須) - SQL実行ID
- 例: `/SQL/execution/?id=0`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| id | 入力（URLパラメータ） | Long | 必須 | SQL実行ID |

## 表示項目

### サマリーセクション

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Submitted Time | Date | 実行開始日時 |
| Duration | Long | 実行時間 |
| Query ID | String | クエリID（設定時のみ表示） |
| Parent Execution | Long | 親実行ID（rootExecutionIdと異なる場合のみ表示、リンク付き） |
| Sub Executions | Seq[Long] | 子実行ID一覧（groupSubExecutionEnabled時のみ表示、各リンク付き） |
| Running Jobs | Seq[Int] | 実行中のジョブID一覧（リンク付き） |
| Succeeded Jobs | Seq[Int] | 成功したジョブID一覧（リンク付き） |
| Failed Jobs | Seq[Int] | 失敗したジョブID一覧（リンク付き） |

### Plan Visualization セクション

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| DAGグラフ | SVG | D3.js/dagre-d3によるDAGグラフ。物理実行計画のノードとメトリクスを表示 |
| Show Stage ID and Task ID チェックボックス | Boolean | 最大メトリクスに対応するStage ID/Task IDの表示切替 |
| Download（SVG/DOT/TXT） | ファイル | DAGグラフのダウンロード形式選択 |

### Plan Details セクション（折りたたみ、デフォルト非表示）

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Physical Plan Description | String | テキスト形式の物理実行計画 |

### SQL / DataFrame Properties セクション（折りたたみ、デフォルト非表示）

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Name | String | 設定プロパティ名 |
| Value | String | 設定プロパティ値 |

### Pandas API Properties セクション（折りたたみ、デフォルト非表示）

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Name | String | pandas on Spark設定プロパティ名（プレフィックス除去） |
| Value | String | Python repr()形式の設定プロパティ値 |

## イベント仕様

### 1-Plan Visualization展開/折りたたみ

Plan Visualizationセクションのヘッダをクリックすると、DAGグラフの表示/非表示を切り替える。JavaScript関数togglePlanViz()で制御。

### 2-Plan Details展開/折りたたみ

Plan Detailsセクションのヘッダをクリックすると、テキスト形式の物理プランの表示/非表示を切り替える。JavaScript関数clickPhysicalPlanDetails()で制御。デフォルトは非表示。

### 3-SQL / DataFrame Properties展開/折りたたみ

プロパティセクションのヘッダをクリックすると、プロパティテーブルの表示/非表示を切り替える。collapseTableで制御。デフォルトは非表示。

### 4-ジョブIDリンククリック

Running/Succeeded/FailedジョブIDのリンクをクリックすると、ジョブ詳細画面（/jobs/job/?id={jobId}）へ遷移する。

### 5-DAGグラフダウンロード

形式選択ドロップダウン（SVG/DOT/TXT）で形式を選択し、Downloadリンクをクリックすると該当形式でDAGグラフをダウンロードする。

### 6-Stage ID/Task IDチェックボックス

チェックボックスをオンにすると、DAGグラフ上の各メトリクスに対応するStage IDとTask IDが表示される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | - | SELECT | SQLAppStatusStore.execution()でKVStoreから特定SQL実行データを取得 |
| ページ表示 | - | SELECT | SQLAppStatusStore.executionMetrics()でメトリクスデータを取得 |
| ページ表示 | - | SELECT | SQLAppStatusStore.planGraph()でDAGグラフデータを取得 |

本画面はデータベースへの更新操作を行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 情報 | "No information to display for query {executionId}" | 指定IDのSQL実行データが存在しない場合 |
| MSG-002 | エラー | "Missing execution id parameter" | idパラメータが未指定の場合 |

## 例外処理

- idパラメータ未指定: require文でIllegalArgumentExceptionがスローされる
- 指定IDの実行データなし: "No information to display for query {executionId}"メッセージが表示される

## 備考

- DAGグラフの描画にはD3.js、dagre-d3.min.js、graphlib-dot.min.js、spark-sql-viz.jsの4つのJavaScriptライブラリを使用
- spark-sql-viz.cssでDAGグラフのスタイルを定義
- modifiedConfigsからpandas_on_Spark.プレフィックスの設定を分離して別セクションで表示
- Pandas API PropertiesではPython repr()風の値変換（JNull->None, JBool->True/False, JString->'値'）を行う
- planGraph()メソッドがSparkPlanGraphを返し、makeDotFile(metrics)でDOT形式のグラフ定義を生成

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SQLAppStatusStore.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusStore.scala` | SQLExecutionUIDataクラス、executionMetrics、planGraphメソッドの戻り値型を確認 |
| 1-2 | SparkPlanGraph.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SparkPlanGraph.scala` | SparkPlanGraphクラスとmakeDotFileメソッド。DAGグラフの構造定義 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExecutionPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/ExecutionPage.scala` | 行32-37: クラス定義。WebUIPage("execution")でURLパスを設定 |

**主要処理フロー**:
1. **行41-43**: idパラメータ取得とrequireチェック
2. **行46**: sqlStore.execution(executionId)でSQL実行データを取得
3. **行47-49**: duration計算
4. **行51-65**: jobLinksヘルパー関数でジョブリンク生成
5. **行68-124**: summary HTML生成（ジョブリンク・ダウンロードボタン含む）
6. **行126-128**: metrics/graph/configs取得
7. **行131-136**: planVisualization + physicalPlanDescription + modifiedConfigs + pandasOnSparkConfigsを結合
8. **行141-142**: UIUtils.headerSparkPageでラップ

#### Step 3: DAGグラフ生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExecutionPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/ExecutionPage.scala` | 行156-184: planVisualizationメソッド。DOTファイル生成とJavaScriptリソース読み込み |
| 3-2 | spark-sql-viz.js | `sql/core/src/main/resources/org/apache/spark/sql/execution/ui/static/spark-sql-viz.js` | DAGグラフの描画ロジック |

### プログラム呼び出し階層図

```
SQLTab [行24]
    |
    +-- ExecutionPage (WebUIPage("execution")) [行34]
            |
            +-- render(request) [行40]
                    |
                    +-- sqlStore.execution(executionId) [行46]
                    |
                    +-- sqlStore.executionMetrics(executionId) [行126]
                    |
                    +-- sqlStore.planGraph(executionId) [行127]
                    |       |
                    |       +-- SparkPlanGraph.makeDotFile(metrics) [行179]
                    |
                    +-- planVisualization(request, metrics, graph) [行131]
                    |       |
                    |       +-- planVisualizationResources(request) [行182]
                    |
                    +-- physicalPlanDescription() [行132]
                    |
                    +-- modifiedConfigs() [行133]
                    |
                    +-- modifiedPandasOnSparkConfigs() [行134-135]
                    |
                    +-- UIUtils.headerSparkPage() [行141]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

id ──────────────────────> ExecutionPage.render()
(URLパラメータ)                    |
                                   +---> SQLAppStatusStore
                                   |     .execution(id)
                                   |     .executionMetrics(id)
                                   |     .planGraph(id)
                                   |           |
                                   +---> サマリーHTML（ジョブリンク等）
                                   |
                                   +---> planVisualization() ──────> DAGグラフHTML
                                   |     (DOTファイル + D3.js)
                                   |
                                   +---> physicalPlanDescription() > テキストプランHTML
                                   |
                                   +---> modifiedConfigs() ────────> プロパティテーブルHTML
                                   |
                                   +---> headerSparkPage() ────────> 完成ページHTML
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ExecutionPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/ExecutionPage.scala` | ソース | メイン画面ページクラス |
| SQLTab.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLTab.scala` | ソース | SQLタブ定義 |
| SQLAppStatusStore.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusStore.scala` | ソース | SQL実行データストア |
| SparkPlanGraph.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SparkPlanGraph.scala` | ソース | DAGグラフデータ構造 |
| spark-sql-viz.js | `sql/core/src/main/resources/org/apache/spark/sql/execution/ui/static/spark-sql-viz.js` | JavaScript | DAGグラフ描画ロジック |
| spark-sql-viz.css | `sql/core/src/main/resources/org/apache/spark/sql/execution/ui/static/spark-sql-viz.css` | CSS | DAGグラフスタイル |
| d3.min.js | `core/src/main/resources/org/apache/spark/ui/static/d3.min.js` | JavaScript | D3.jsライブラリ |
| dagre-d3.min.js | `core/src/main/resources/org/apache/spark/ui/static/dagre-d3.min.js` | JavaScript | DAGレイアウトライブラリ |
| graphlib-dot.min.js | `core/src/main/resources/org/apache/spark/ui/static/graphlib-dot.min.js` | JavaScript | DOT形式パーサー |
